/* --------------------------------------------------------------
  EventsEmitter.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

export default {
	/**
	 * Trigger Style Created Event
	 *
	 * @param {jQuery} $element The element that is going to trigger the event.
	 * @param {*[]} eventArgs (optional) Provide event arguments.
	 */
	triggerStyleCreated($element, eventArgs) {
		eventArgs = eventArgs || [];
		$element.trigger('StyleEdit.StyleCreated', eventArgs);
	},
	
	/**
	 * Trigger Style Updated Event
	 *
	 * @param {jQuery} $element The element that is going to trigger the event.
	 * @param {*[]} eventArgs (optional) Provide event arguments.
	 */
	triggerStyleUpdated($element, eventArgs) {
		eventArgs = eventArgs || [];
		$element.trigger('StyleEdit.StyleUpdated', eventArgs);
	},
	
	/**
	 * Trigger Style Deleted Event
	 *
	 * @param {jQuery} $element The element that is going to trigger the event.
	 * @param {*[]} eventArgs (optional) Provide event arguments.
	 */
	triggerStyleDeleted($element, eventArgs) {
		eventArgs = eventArgs || [];
		$element.trigger('StyleEdit.StyleDeleted', eventArgs);
	},
	
	/**
	 * Trigger Style Activated Event
	 *
	 * @param {jQuery} $element The element that is going to trigger the event.
	 * @param {*[]} eventArgs (optional) Provide event arguments.
	 */
	triggerStyleActivated($element, eventArgs) {
		eventArgs = eventArgs || [];
		$element.trigger('StyleEdit.StyleActivated', eventArgs);
	},
	
	/**
	 * Trigger Custom Styles Changed Event
	 *
	 * @param {jQuery} $element The element that is going to trigger the event.
	 * @param {*[]} eventArgs (optional) Provide event arguments.
	 */
	triggerCustomStylesChanged($element, eventArgs) {
		eventArgs = eventArgs || [];
		$element.trigger('StyleEdit.CustomStylesChanged', eventArgs);
	},
	
	/**
	 * Trigger Controller Initialized Event
	 *
	 * @param {jQuery} $element The element that is going to trigger the event.
	 * @param {*[]} eventArgs (optional) Provide event arguments.
	 */
	triggerControllerInitialized($element, eventArgs) {
		eventArgs = eventArgs || [];
		$element.trigger('StyleEdit.ControllerInitialized', eventArgs);
	},
	
	/**
	 * Trigger Controller Destroyed Event
	 *
	 * @param {jQuery} $element The element that is going to trigger the event.
	 * @param {*[]} eventArgs (optional) Provide event arguments.
	 */
	triggerControllerDestroyed($element, eventArgs) {
		eventArgs = eventArgs || [];
		$element.trigger('StyleEdit.ControllerDestroyed', eventArgs);
	},
	
	/**
	 * Trigger App Terminated Event
	 *
	 * @param {jQuery} $element The element that is going to trigger the event.
	 * @param {*[]} eventArgs (optional) Provide event arguments.
	 */
	triggerAppTerminated($element, eventArgs) {
		eventArgs = eventArgs || [];
		$element.trigger('StyleEdit.AppTerminated', eventArgs);
	},
	
	/**
	 * Trigger Preview Reloaded Event
	 *
	 * @param {jQuery} $element The element that is going to trigger the event.
	 * @param {*[]} eventArgs (optional) Provide event arguments.
	 */
	triggerPreviewReloaded($element, eventArgs) {
		eventArgs = eventArgs || [];
		$element.trigger('StyleEdit.PreviewReloaded', eventArgs);
	}
}
